import java.util.*;

public class Main {

    static class Tacka implements Comparable<Tacka> {
        long x, y;

        Tacka(long x, long y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public int compareTo(Tacka druga) {
            return x != druga.x ? Long.compare(x, druga.x) : Long.compare(y, druga.y);
        }
    }


    static long vektorskiProizvod(Tacka a, Tacka b, Tacka c) {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
    }


    static long povrsinaMnogoUgla(List<Tacka> omotac) {
        long povrsina = 0;
        int n = omotac.size();
        for (int i = 0; i < n; i++) {
            Tacka prva = omotac.get(i);
            Tacka druga = omotac.get((i + 1) % n);
            povrsina += prva.x * druga.y - prva.y * druga.x;
        }
        return Math.abs(povrsina);
    }


    static List<Tacka> konveksniOmotac(Tacka[] tacke) {
        Arrays.sort(tacke);
        List<Tacka> omotac = new ArrayList<>();


        for (Tacka t : tacke) {
            while (omotac.size() >= 2 &&
                    vektorskiProizvod(omotac.get(omotac.size() - 2), omotac.get(omotac.size() - 1), t) <= 0) {
                omotac.remove(omotac.size() - 1);
            }
            omotac.add(t);
        }


        int t = omotac.size() + 1;
        for (int i = tacke.length - 2; i >= 0; i--) {
            while (omotac.size() >= t &&
                    vektorskiProizvod(omotac.get(omotac.size() - 2), omotac.get(omotac.size() - 1), tacke[i]) <= 0) {
                omotac.remove(omotac.size() - 1);
            }
            omotac.add(tacke[i]);
        }

        omotac.remove(omotac.size() - 1);
        return omotac;
    }

    public static void main(String[] args) {
        Scanner skener = new Scanner(System.in);
        int brojTacaka = skener.nextInt();
        Tacka[] tacke = new Tacka[brojTacaka];

        for (int i = 0; i < brojTacaka; i++) {
            long x = skener.nextLong();
            long y = skener.nextLong();
            tacke[i] = new Tacka(x, y);
        }


        List<Tacka> omotac = konveksniOmotac(tacke);
        long minimalnaPovrsina = Long.MAX_VALUE;


        for (int i = 0; i < omotac.size(); i++) {
            List<Tacka> privremeniOmotac = new ArrayList<>(omotac);
            privremeniOmotac.remove(i);
            minimalnaPovrsina = Math.min(minimalnaPovrsina, povrsinaMnogoUgla(privremeniOmotac));
        }

        System.out.println(minimalnaPovrsina / 2);
    }
}